<?php require_once('Auth/authorize.php');?>
<?php include_once('partials/agent_functions.php');?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8" />
		<style>
			.invoice-box {
				max-width: 800px;
				margin: auto;
				padding: 30px;
				border: 1px solid #eee;
				box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
				font-size: 16px;
				line-height: 24px;
				font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
				color: #555;
			}
.line {
	border-top:1px solid black;
}
			.invoice-box table {
				width: 100%;
				line-height: inherit;
				text-align: left;
			}

			.invoice-box table td {
				padding: 5px;
				vertical-align: top;
			}

			.invoice-box table tr td:nth-child(2) {
				text-align: right;
			}

			.invoice-box table tr.top table td {
				padding-bottom: 20px;
			}

			.invoice-box table tr.top table td.title {
				font-size: 45px;
				line-height: 45px;
				color: #333;
			}

			.invoice-box table tr.information table td {
				padding-bottom: 40px;
			}

			.invoice-box table tr.heading td {
				background: #eee;
				border-bottom: 1px solid #ddd;
				font-weight: bold;
			}

			.invoice-box table tr.details td {
				padding-bottom: 20px;
			}

			.invoice-box table tr.item td {
				border-bottom: 1px solid #eee;
			}

			.invoice-box table tr.item.last td {
				border-bottom: none;
			}

			.invoice-box table tr.total td:nth-child(2) {
				border-top: 2px solid #eee;
				font-weight: bold;
			}

			@media only screen and (max-width: 600px) {
				.invoice-box table tr.top table td {
					width: 100%;
					display: block;
					text-align: center;
				}

				.invoice-box table tr.information table td {
					width: 100%;
					display: block;
					text-align: center;
				}
			}

			/** RTL **/
			.invoice-box.rtl {
				direction: rtl;
				font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
			}

			.invoice-box.rtl table {
				text-align: right;
			}

			.invoice-box.rtl table tr td:nth-child(2) {
				text-align: left;
			}
            @media print {
  .invoice-box {
    max-width: unset;
    box-shadow: none;
    border: 0px;
  }
}
		</style>
	</head>

	<body>

    <?php
    $transactionID = $_GET['TRID'];
    $transaction = getTransactionById($transactionID);
    if (!$transaction) {
    echo "<script>alert('Please Provide Transaction ID)</script>";
    exit;
    }

    ?>
		<div class="invoice-box">
			<table cellpadding="0" cellspacing="0">
				<tr class="top">
					<td colspan="2">
						<table>
							<tr>
								<td class="title">
									<img src="../Admin/images/adson.png" style="width: 100%; max-width: 100px" />
								</td>

								<td>
								Agent Copy #<?php echo htmlspecialchars($transaction['id']); ?><br/>                         
									Created: <?php echo date('F j, Y - g:i A', strtotime($transaction['transaction_time'])); ?>
<br />
									Completed:<?php echo date('F j, Y g:i A', strtotime($transaction['completed_at'])); ?>

								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr class="heading">
					<td>Payment Method</td>

					<td>Customer Signature</td>
				</tr>

				<tr class="details">
					<td><?php echo htmlspecialchars($transaction['operator']); ?></td>

					<td>_______________________</td>
				</tr>

				<tr class="heading">
					<td>Details</td>

					<td>Values</td>
				</tr>

				<tr class="item">
					<td>Transaction ID:</td>

					<td><b><?php echo htmlspecialchars($transaction['transaction_id']); ?></b></td>
				</tr>
				<tr class="item">
					<td>Sender's Name:</br><b><?php echo htmlspecialchars($transaction['sender_name']); ?></b></td>

					<td>Sender's Number:</br><b><?php echo htmlspecialchars($transaction['sender_number']); ?></b></td>
				</tr>

				<tr class="item">
					<td>Reciever's Name:</br><b><?php echo htmlspecialchars($transaction['reciever_name']); ?></b></td>

					<td>Reciever's Number:</br><b><?php echo htmlspecialchars($transaction['reciever_number']); ?></b></td>
				</tr>



				<tr class="total">
					<td><b>Served By: </b><i><?php if($transaction['completed_by'] != ""){echo htmlspecialchars($transaction['completed_by']);}else{echo htmlspecialchars($transaction['served_by']);} ?></i></td>

					<td>Amount: $<?php echo htmlspecialchars($transaction['amount']); ?>.00</td>
				</tr>
			</table>
		</div>
		<div class="invoice-box line">
			<table cellpadding="0" cellspacing="0">
				<tr class="top">
					<td colspan="2">
						<table>
							<tr>
								<td class="title">
									<img src="../Admin/images/adson.png" style="width: 100%; max-width: 100px" />
								</td>
								<td>
								Customer Copy #<?php echo htmlspecialchars($transaction['id']); ?><br/>                        
									Created: <?php echo date('F j, Y - g:i A', strtotime($transaction['transaction_time'])); ?>
<br />
									Completed:<?php echo date('F j, Y g:i A', strtotime($transaction['completed_at'])); ?>

								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr class="information">
					<td colspan="2">
						<table>
							<tr>
								<td>
									Nabugabo Road, 
									Best Bargaining center, BBC Romom N429<br />
									<b>Served By: </b><i><?php if($transaction['completed_by'] != ""){echo htmlspecialchars($transaction['completed_by']);}else{echo htmlspecialchars($transaction['served_by']);} ?></i>
								</td>

								<td>
								
									+256 777 588 443<br />
									+256 704 085 953
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr class="heading">
					<td>Payment Method</td>

					<td>Customer Signature</td>
				</tr>

				<tr class="details">
					<td><?php echo htmlspecialchars($transaction['operator']); ?></td>

					<td>_______________________</td>
				</tr>

				<tr class="heading">
					<td>Details</td>

					<td>Values</td>
				</tr>

				<tr class="item">
					<td>Transaction ID:</td>

					<td><b><?php echo htmlspecialchars($transaction['transaction_id']); ?></b></td>
				</tr>
				<tr class="item">
					<td>Sender's Name:</br><b><?php echo htmlspecialchars($transaction['sender_name']); ?></b></td>

					<td>Sender's Number:</br><b><?php echo htmlspecialchars($transaction['sender_number']); ?></b></td>
				</tr>

				<tr class="item">
					<td>Reciever's Name:</br><b><?php echo htmlspecialchars($transaction['reciever_name']); ?></b></td>

					<td>Reciever's Number:</br><b><?php echo htmlspecialchars($transaction['reciever_number']); ?></b></td>
				</tr>



				<tr class="total">
					<td></td>

					<td>Amount: $<?php echo htmlspecialchars($transaction['amount']); ?>.00</td>
				</tr>
			</table>
		</div>
	</body>
</html>